﻿/**
 * 成绩管理js
 * 
 * @since 2018/05/03
 * @author xusw
 */
$(function() {
	creatGrid();

	//查看窗口
	$('#seewin').window({    
		width : 800,
		height : 500,
		draggable : false,
		resizable : false,
		collapsible : false,
		minimizable : true,
		maximizable : true,
		closable : true,
		closed : true,
		inline : true,
		maximized:true,
		title : 'view exam paper',
		modal : true   
	});
	$('#searchUserGroup').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
		panelMinWidth:250,
		panelMinHeight:300,
		panelMaxWidth:400,
		panelMaxHeight:500,
		animate : true,
		editable : false,
		url : baseUrl + '/admin/U030/findGroupAddALL.html',
		required : false,
		onHidePanel : getChildren
	});
});
function creatGrid() {
	$('#itemlist').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : true,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 15,// 每页显示的记录条数，默认为10
		pageList : [ 15, 30, 50, 100 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl +"/admin/T100/listDailyPracticeResult.html",
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'name',
			title : 'daily practice name',
			width : 120,
			sortable : true,
			halign: 'center',
			align : 'left'
		}, {
			
			field : 'times',
			title : 'exam times',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'totalsorce',
			title : 'exam paper total score',
			width : 50,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'sorce',
			title : 'practice score',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'dailyDate',
			title : 'practicce ending time',
			width :120,
			formatter : fmdate,
			sortable : true,
			halign: 'center',
			align : 'center'
		},{
			field : 'totalTm',
			title : 'practice time length',
			width : 60,
			sortable : true,
			halign: 'center',
			align : 'right'
		},{
			field : 'ksuserName',
			title : 'examinee user name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'ksrealName',
			title : 'examinee real name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'positionname',
			title : 'examinee position',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'groupName',
			title : 'examinee group name',
			width : 80,
			sortable : true,
			align : 'left'
		}, {
			field : 'manage',
			title : 'manage',
			align : 'center',
			width : 100,
			formatter : fmup
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.see_chengji').linkbutton({
				iconCls : 'icon-search',
				plain : true
			});
			$('.del_chengji').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});

}
function fmup(value, rowData, rowIndex) {
	var id = rowData.id;
	var str="<a onclick='openSeeWin("+ id+")' class='see_chengji'>see</a>";
	str += "<a onclick='delCjById("+ id+");' class='del_chengji' >delete</a>";
	return str;
}
//======================================查看试卷=================================//
//打开查看窗口
function openSeeWin(id) {
	window.parent.closeTabByTitle("daily practice score preview");
	window.parent.openTab("daily practice score preview", baseUrl+"/admin/T100/dailyPracticeResultPreview.html?id="+id);
}
function getData(id){
	alert(id);
	$.post(baseUrl +"/admin/T070/getExamPaper.html", {
	id : id
	}, function(data) {	
		loadSjInfo(data);
	}, "json");
}
function loadSjInfo(data){
	//卷子名
	var sjname=data.kstitle;
	//alert(sjname);
	//固定题
	var gud_shitimix=eval("("+data.d_shitimix+")");
	var gud_shitimix=eval("("+gud_shitimix.data+")");
	//容器
	var C=$("#seewin");
	C.append(sjname);
	for(var i=0;i<gud_shitimix.length;i++){
		var html='<p>';
		html+=gud_shitimix[i].title;
		html+='</p>';
		C.append(html);
	}
}
//======================================查看结束=================================//
//日期转换
function fmdate(value, rowData, rowIndex) {
	// fmtLongDate--common.js
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}

//查询
function seachChengjiByParam() {
	//给隐藏表单赋值
	var title=$("#title").val();
	var ksusername=$("#ksusername").val();
	var param = {
		title : title,
		username:ksusername
	};
	$('#itemlist').datagrid('load', param);
}
//刷新
function reloadGrid() {
	$('#itemlist').datagrid('clearSelections');
	$('#itemlist').datagrid('reload');
}

//删除用户
function delCjById(id) {
	var items_id = new Array();
	items_id.push(id);
	$.messager.confirm('delete hint', 'make sure to delete the selected score?', function(r) {
		if (r) {
			$.post(baseUrl +"/admin/T100/removeDailyPracticeResult.html", {
				ids : items_id
			}, function(data) {
				if (data > 0) {
					msgShow('delete success!');
					reloadGrid();
				} else {
					msgShow('delete failure,please try again later');
					reloadGrid();
				}
			}, "json");
		}else{
			$('#itemlist').datagrid('clearSelections');
		}
	});
}
//删除用户提示
function delCjMessage() {
	$.messager.confirm('delete hint', 'make sure to delete the selected score?', function(r) {
		if (r) {
			delCj();
		}else{
			$('#itemlist').datagrid('clearSelections');
		}
	});
}
//删除用户
function delCj() {
	var items_id = new Array();
	var items = $('#itemlist').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('hint', 'please select the score need deleted ', 'info');
		return;
	}
	// 获取选中用户的ID，并组成集合
	for ( var i = 0; i < items.length; i++) {
		items_id.push(items[i].id);
	}
	$.post(baseUrl +"/admin/T100/removeDailyPracticeResult.html", {
		ids : items_id
	}, function(data) {
		if (data > 0) {
			msgShow('delete success!');
			reloadGrid();
		} else {
			msgShow('delete failure,please try again later');
			reloadGrid();
		}
	}, "json");
}